<?php
/**
 * @version        3.9.5
 * @package        Joomla
 * @subpackage     EShop
 * @author         Giang Dinh Truong
 * @copyright      Copyright (C) 2011 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

// Include the helper functions only once
require_once JPATH_ROOT . '/components/com_eshop/helpers/helper.php';
require_once __DIR__ . '/helper.php';

$currencies = modEShopCurrencyHelper::getCurrencies();
$document   = Factory::getApplication()->getDocument();
$template   = Factory::getApplication()->getTemplate();

//Load CSS of component
EShopHelper::loadComponentCssForModules();

if (is_file(JPATH_SITE . '/templates/' . $template . '/css/' . $module->module . '.css'))
{
	$document->addStyleSheet(Uri::base() . 'templates/' . $template . '/css/' . $module->module . '.css');
}
else
{
	$document->addStyleSheet(Uri::base() . 'modules/' . $module->module . '/css/style.css');
}

$session = Factory::getApplication()->getSession();
$input   = Factory::getApplication()->input;

if ($session->get('currency_code'))
{
	$currencyCode = $session->get('currency_code');
}
elseif ($input->getString('currency_code', '', 'COOKIE'))
{
	$currencyCode = $input->getString('currency_code', '', 'COOKIE');
}
else
{
	$currencyCode = EShopHelper::getConfigValue('default_currency_code');
}

//Load JQuery Framework
if (EShopHelper::getConfigValue('load_jquery_framework', 1))
{
	HTMLHelper::_('jquery.framework');
}

require ModuleHelper::getLayoutPath('mod_eshop_currency', $params->get('layout', 'default'));
